#include "genTex.h"
#include <math.h>

GLuint genLaserTex(unsigned int w,unsigned int h,float r,float g,float b,float alphaMin,float alphaMax)
{
    if((w & 0x01)||(h & 0x01))return 0xFFFFFFFF;
    
    unsigned int wd2=w;
    w*=2;
    
    GLubyte *pixels=new GLubyte[w*h*4];
    if(!pixels)return 0xFFFFFFFF;
    
    GLubyte br,bg,bb,ba;
    float tr,tg,tb,ta;
    float dr,dg,db,da;
    
    unsigned int hd2=h/2;
    unsigned int rn=wd2/2;
    
    if(rn>hd2)rn=hd2;
    
    GLubyte *ptr1,*ptr2;
    
    ptr1=pixels;
    ptr2=pixels+((w*h-wd2-1)<<2)+3;
    
    float coefIntrepol;
    
    dr=(0.5-r);
    dg=(0.5-g);
    db=(0.5-b);
    da=(alphaMax-alphaMin);
    
    unsigned int j,i;
    
    for(j=0;j<hd2;j++)
    {
        //calcul color
        coefIntrepol=j;
        coefIntrepol/=((float)(hd2-1));
        coefIntrepol*=coefIntrepol;
        
        tr=r+dr*coefIntrepol;
        tg=g+dg*coefIntrepol;
        tb=b+db*coefIntrepol;
        ta=alphaMin+da*coefIntrepol;
        
        if(tr>=1.0)br=0xFF;else if(tr<=0.0)br=0x00;else br=(GLubyte)(255*tr);
        if(tg>=1.0)bg=0xFF;else if(tg<=0.0)bg=0x00;else bg=(GLubyte)(255*tg);
        if(tb>=1.0)bb=0xFF;else if(tb<=0.0)bb=0x00;else bb=(GLubyte)(255*tb);
        if(ta>=1.0)ba=0xFF;else if(ta<=0.0)ba=0x00;else ba=(GLubyte)(255*ta);
        
        for(i=0;i<wd2;i++)
        {
            *ptr1=br;ptr1++;
            *ptr1=bg;ptr1++;
            *ptr1=bb;ptr1++;
            *ptr1=ba;ptr1++;
            
            *ptr2=ba;ptr2--;
            *ptr2=bb;ptr2--;
            *ptr2=bg;ptr2--;
            *ptr2=br;ptr2--;
        }
        ptr1+=(wd2<<2);
        ptr2-=(wd2<<2);
    }
    
    unsigned int rnSQR=rn;
    rnSQR*=rnSQR;
    
    float fx1,cct;
    unsigned int x1;
    
    for(j=0;j<rn;j++)
    {
        fx1=(rn-1)-j;
        fx1*=fx1;
        fx1=sqrtf(rnSQR-fx1);
        fx1=rn-fx1;
        if(fx1<=0.0)x1=0;else x1=(unsigned int)fx1;
        
        ptr1=pixels+((w*j+wd2)<<2);
        
        for(i=0;i<x1;i++)
        {
            *ptr1=0x00;ptr1++;
            *ptr1=0x00;ptr1++;
            *ptr1=0x00;ptr1++;
            *ptr1=0x00;ptr1++;
        }
        
        cct=1.0-(j/((float)(rn-1)));
        cct*=cct;
        
        for(/*i=x1*/;i<rn;i++)
        {
            coefIntrepol=1.0-(i/((float)(rn-1)));
            coefIntrepol*=coefIntrepol;
            coefIntrepol+=cct;
            coefIntrepol=1.0-sqrtf(coefIntrepol);
            coefIntrepol*=coefIntrepol;
            
            tr=r+dr*coefIntrepol;
            tg=g+dg*coefIntrepol;
            tb=b+db*coefIntrepol;
            ta=alphaMin+da*coefIntrepol;
            
            if(tr>=1.0)br=0xFF;else if(tr<=0.0)br=0x00;else br=(GLubyte)(255*tr);
            if(tg>=1.0)bg=0xFF;else if(tg<=0.0)bg=0x00;else bg=(GLubyte)(255*tg);
            if(tb>=1.0)bb=0xFF;else if(tb<=0.0)bb=0x00;else bb=(GLubyte)(255*tb);
            if(ta>=1.0)ba=0xFF;else if(ta<=0.0)ba=0x00;else ba=(GLubyte)(255*ta);
            
            *ptr1=br;ptr1++;
            *ptr1=bg;ptr1++;
            *ptr1=bb;ptr1++;
            *ptr1=ba;ptr1++;
        }
    }
    
    GLuint *ptrI1,*ptrI2;
    
    for(j=0;j<rn;j++)
    {
        ptrI1=((GLuint*)pixels)+w*j+wd2+(rn-1);
        ptrI2=ptrI1+1;
        
        for(i=0;i<rn;i++)
        {
            *ptrI2=*ptrI1;
            ptrI1--;
            ptrI2++;
        }
    }
    
    ptrI1=((GLuint*)pixels)+w*(rn-1)+wd2;
    rn*=2;
    ptrI2=ptrI1+w;
    ptrI1+=rn-1;
    
    for(j=hd2;j<h;j++)
    {
        for(i=0;i<rn;i++)
        {
            *ptrI2=*ptrI1;
            ptrI1--;
            ptrI2++;
        }
        ptrI1=ptrI1+rn-w;
        ptrI2=ptrI2-rn+w;
    }
    
    GLuint res;
    glGenTextures( 1, &res );
    glBindTexture( GL_TEXTURE_2D, res );
    
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
    
    glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA,w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, pixels );
    
    delete []pixels;
    
    return res;
}

GLuint genLightTex(unsigned int w,unsigned int h,float r1,float g1,float b1,float r2,float g2,float b2,float alphaMin,float alphaMax)
{
    if((w & 0x01)||(h & 0x01))return 0xFFFFFFFF;
    
    GLubyte *pixels=new GLubyte[w*h*4];
    if(!pixels)return 0xFFFFFFFF;
    
    GLubyte br,bg,bb,ba;
    float tr,tg,tb,ta;
    float dr,dg,db,da;
    
    unsigned int hd2=h/2;
    unsigned int rn=w/2;
    
    if(rn>hd2)rn=hd2;
    
    float coefIntrepol;
    
    dr=(r2-r1);
    dg=(g2-g1);
    db=(b2-b1);
    da=(alphaMax-alphaMin);
    
    unsigned int j,i;
    
    unsigned int rnSQR=rn;
    rnSQR*=rnSQR;
    
    float fx1,cct;
    unsigned int x1;
    
    GLubyte *ptr1;
    
    for(j=0;j<rn;j++)
    {
        fx1=(rn-1)-j;
        fx1*=fx1;
        fx1=sqrtf(rnSQR-fx1);
        fx1=rn-fx1;
        if(fx1<=0.0)x1=0;else x1=(unsigned int)fx1;
        
        ptr1=pixels+((w*j)<<2);
        
        for(i=0;i<x1;i++)
        {
            *ptr1=0x00;ptr1++;
            *ptr1=0x00;ptr1++;
            *ptr1=0x00;ptr1++;
            *ptr1=0x00;ptr1++;
        }
        
        cct=1.0-(j/((float)(rn-1)));
        cct*=cct;
        
        for(/*i=x1*/;i<rn;i++)
        {
            coefIntrepol=1.0-(i/((float)(rn-1)));
            coefIntrepol*=coefIntrepol;
            coefIntrepol+=cct;
            coefIntrepol=1.0-sqrtf(coefIntrepol);
            coefIntrepol*=coefIntrepol;
            
            tr=r1+dr*coefIntrepol;
            tg=g1+dg*coefIntrepol;
            tb=b1+db*coefIntrepol;
            ta=alphaMin+da*coefIntrepol;
            
            if(tr>=1.0)br=0xFF;else if(tr<=0.0)br=0x00;else br=(GLubyte)(255*tr);
            if(tg>=1.0)bg=0xFF;else if(tg<=0.0)bg=0x00;else bg=(GLubyte)(255*tg);
            if(tb>=1.0)bb=0xFF;else if(tb<=0.0)bb=0x00;else bb=(GLubyte)(255*tb);
            if(ta>=1.0)ba=0xFF;else if(ta<=0.0)ba=0x00;else ba=(GLubyte)(255*ta);
            
            *ptr1=br;ptr1++;
            *ptr1=bg;ptr1++;
            *ptr1=bb;ptr1++;
            *ptr1=ba;ptr1++;
        }
    }
    
    GLuint *ptrI1,*ptrI2;
    
    for(j=0;j<rn;j++)
    {
        ptrI1=((GLuint*)pixels)+w*j+(rn-1);
        ptrI2=ptrI1+1;
        
        for(i=0;i<rn;i++)
        {
            *ptrI2=*ptrI1;
            ptrI1--;
            ptrI2++;
        }
    }
    
    ptrI1=((GLuint*)pixels)+w*(rn-1);
    rn*=2;
    ptrI2=ptrI1+w;
    ptrI1+=rn-1;
    
    for(j=hd2;j<h;j++)
    {
        for(i=0;i<rn;i++)
        {
            *ptrI2=*ptrI1;
            ptrI1--;
            ptrI2++;
        }
        ptrI1=ptrI1+rn-w;
        ptrI2=ptrI2-rn+w;
    }
    
    GLuint res;
    glGenTextures( 1, &res );
    glBindTexture( GL_TEXTURE_2D, res );
    
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
    
    glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA,w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, pixels );
    
    delete []pixels;
    
    return res;
}
